#!/bin/bash

# Repeater SW v.07
#
# maxlinux2000@gmail.com
# max2k@preparandonos.es
#
# This script works with Linux and common audio cards both pci and usb.
# Tested on an old HP laptop running ubuntu 20.04 and using a RaspberryPi compatible usb audio card.
# In this way I make sure that later it works with a RaspberryPi or another microcomputer with ARM.
# I have used a PMR466 midland G7pro as a repeater radio.
# It's need to be activated the vox and disable the auto-roger on the pepeater radio


# 2021-12-17 - version 0.5
# 2023-01-02 - version 0.6
# 2023-01-20 - version 0.7 # for Apocalipsis, now sen message via email
# 2024-07-20 - version 0.8 # added DTMF control
# 2024-07-21 - version 0.9 1 added times and sysop control
# 2024-08-01 - version 0.9.2 some fixes


if [ ! -f $HOME/.loro-config ]; then
    /usr/local/bin/loro-config.sh
fi

source $HOME/.loro-config

ENABLE=0
RAMDISK=/dev/shm

# reset Time watchdog
echo "1" > /dev/shm/yo/watchdog.log

# Start - don't touch below
################################

mkdir -p $RAMDISK/$USER/vox
rm $RAMDISK/$USER/audio*.wav 2>/dev/null

DURATION=$(echo "($MinMexDuration * 1000000)/1" | bc) #" ### don't touch please
#rm $RAMDISK/$USER/vox/vox.wav 
#if [ ! -f $RAMDISK/$USER/vox/vox.wav ]; then
#    sox -V -r $FREQ -n -b 16 -c 1 $RAMDISK/$USER/vox/vox.wav synth 0.5 sin 440 vol -10dB
#fi
#cp /usr/local/share/loro/sounds/messagereceived.wav $RAMDISK/$USER/vox/

SystemStop=0
ENABLE=0

while true; do
    echo "monitoring..."
    rm *.wav  2> /dev/null
    if [ $SystemStop = 0 ]; then
        TotTimeDone=$(while read -r num; do ((sum += num)); done <  /dev/shm/yo/watchdog.log; echo $sum)
        if [ $TotTimeDone -gt $TimeTotal ]; then
            ENABLE=0
            SystemStop=1
        else
            SystemStop=0
        fi
    fi
    echo "
    ENABLE=$ENABLE
    SystemStop=$SystemStop
    TotTimeDone=$TotTimeDone
   "
    clear
    echo "
########################################################
# DTMF=$DTMF - ENABLE=$ENABLE - SystemStop=$SystemStop - TotTimeDone=$TotTimeDone 
########################################################"
    AUDIODRIVER=$AUDIODRIVER AUDIODEV=$AUDIODEV rec -V0 -r $FREQ -e signed-integer -b 16 -c 1 --endian little   -p  | sox -p -p silence 0 1 0:$TIME 10% | sox -p -r $FREQ -e signed-integer -b 16 -c 1 --endian little $RAMDISK/$USER/audio.wav compand 0.3,1 6:-70,-60,-20 -5 -90 0.2   silence 0 1 0:02 10% : newfile

#     AUDIODRIVER=$AUDIODRIVER AUDIODEV=$AUDIODEV rec -V3 compand 0.3,1 6:-70,-60,-20 -5 -90 0.2 trim 0 10 -p | sox -p -p silence 0 1 0:$TIME 10% | sox -p -r $FREQ -e signed-integer -b 16 -c 1 --endian little $RAMDISK/$USER/audio.wav silence 0 1 0:02 10% : newfile
    ls $RAMDISK/$USER/*.wav > $RAMDISK/$USER/list.log
    du $RAMDISK/$USER/*.wav >> $RAMDISK/$USER/size.log

    for audio in $(cat $RAMDISK/$USER/list.log); do
        size=$(cat $audio | wc -l)
        if [ $size == "0" ]; then
            echo "$audio file empty"
            rm $audio
        else
            message=$(echo $audio | sed 's|.wav|_vox.wav|')
            echo "MIX"
            echo message=$message
            size2=$(ffprobe -show_entries format=duration -of default=noprint_wrappers=1:nokey=1 $audio 2>/dev/null | tr -d '.')
            if [ $size2 -lt "$DURATION" ]; then
                echo "$audio file empty"
                rm -f $audio
            else
            # stopped for now. This is now only a repeater parrot
            #    AUDIODRIVER=$AUDIODRIVER  AUDIODEV=$AUDIODEV play $RAMDISK/$USER/vox/vox.wav
            #    AUDIODRIVER=$AUDIODRIVER  AUDIODEV=$AUDIODEV play $RAMDISK/$USER/vox/messagereceived.wav
                DTMF=$(multimon-ng -q -a DTMF -t wav $audio | sed 's|DTMF: ||g' | tr -d '\n' | tr -d '#')
                echo DTMF=$DTMF

                if [ ! -z $DTMF ]; then
                    if [ $DTMF = $STOP ]; then
                        SystemStop=$SystemStop
                        ENABLE=0
                    fi
                    if [ $DTMF = $START ]; then
                        if [ $SystemStop = 0 ]; then
                            ENABLE=1
                            echo "ENABLE=$ENABLE"

                        fi
                    fi
                    if [ $DTMF = $StopSysop ]; then
                        echo STOP
                        SystemStop=1
                        TotTimeDone=1
                        echo "
                        ENABLE=$ENABLE
                        SystemStop=$SystemStop
                        TotTimeDone=$TotTimeDone
                        "
                            clear
                            echo "
########################################################
# DTMF=$DTMF - ENABLE=$ENABLE - SystemStop=$SystemStop - TotTimeDone=$TotTimeDone 
########################################################"

                    fi
                    if [ $DTMF = $StartSysop ]; then
                        echo START
                        ENABLE=1
                        SystemStop=0
                        echo "1" > /dev/shm/yo/watchdog.log
                        echo "
                        ENABLE=$ENABLE
                        SystemStop=$SystemStop
                        TotTimeDone=$TotTimeDone
                        "
                    fi
                else

                    if [ $SystemStop = 0 ]; then
                        if [ $ENABLE = 1 ]; then
                            MexDuration=$(echo "( $size2 / 1000000 )*1" | bc) #"
                            if [ $MexDuration -lt $OneMsg ]; then
                                clear
                                echo "
########################################################
# DTMF=$DTMF - ENABLE=$ENABLE - SystemStop=$SystemStop - TotTimeDone=$TotTimeDone 
########################################################"
                                echo "$MexDuration" >> $RAMDISK/$USER/watchdog.log
                                AUDIODRIVER=$AUDIODRIVER  AUDIODEV=$AUDIODEV play $audio
                            fi

    # STOPPED EMAIL FOR NOW   echo "Acaba de llegar este nuevo mensaje"  | mail -s "Nuevo Mensaje por radio" $USER@$DOMAIN -A $audio
                        fi
                    fi
                    rm $RAMDISK/$USER/*.wav  2> /dev/null
                fi
            fi
        fi
    done
    rm $RAMDISK/$USER/*.wav 2> /dev/null
    sleep 0.3
    :> $RAMDISK/$USER/size.log
    HOUR=$(date '+%Y-%m-%d')
    if [ $HOUR  = 23 ]; then
        echo "1" > /dev/shm/yo/watchdog.log
        SystemStop=0
    fi
done
exit 0
