#!/bin/bash


if [ ! -f /usr/bin/sox ]; then
    sudo apt install sox -y
fi
if [ ! -f /usr/bin/ffmpeg ]; then
    sudo apt install ffmpeg -y
fi

if [ ! -f /usr/bin/zenity ]; then
    sudo apt install zenity -y
fi

if [ ! -f /usr/bin/multimon-ng ]; then
    sudo apt install multimon-ng -y
fi


DiverSelect=$(zenity --list \
    --width="600" \
    --height="300" \
    --title="Selecciona el Driver audio" \
    --column="Driver"  \
    alsa jack pulseaudio)

echo DiverSelect=$DiverSelect

AudioCardsList=$(arecord -L | grep -v "plughw" | grep -A1 "hw:" | sed 's|--||g' | sed 's|^    ||g' | grep  "." | paste -d ' ' - - | tr ' ' '_' )
#echo AudioCardsList=$AudioCardsList


AudioSelect=$(zenity --list \
    --width="600" \
    --height="300" \
    --title="Selecciona la tarjeta audio" \
    --column="tarjeta"  \
    $AudioCardsList)
#AudioCard=$(echo $AudioSelect | cut -d '_' -f1)
AudioCard=$(echo $AudioSelect)
AudioCard=$(echo $AudioCard | cut -d '_' -f1)


SilenceTime=$(zenity --scale --text="Duracción del silencio en segundos/100" --value="150" --min-value="1" --max-value="500" –step="1")
SilenceTime=$(echo "scale=2 ; $SilenceTime/100" | bc)
echo SilenceTime=$SilenceTime

DuratioMin=$(zenity --scale --text="Duracción mínima de un mensaje en segundos/100" --value="290" --min-value="10" --max-value="500" –step="1")
DuratioMin=$(echo "scale=2 ; $DuratioMin/100" | bc)
echo DuratioMin=$DuratioMin

FreqSelect=$(zenity --list \
    --width="600" \
    --height="300" \
    --title="Selecciona la frecuencia de muestreo audio" \
    --column="Freq"  \
    48000 44100 22050 8000)

echo FreqSelect=$FreqSelect


ENABLE=$(zenity --forms --title="CONTRASEÑAS" --text="Activar y desactivar el repetidor" \
   --width="600" \
   --height="300" \
   --text="Aquí se pone las contraseña numérica (PIN) a tu elección. La contraseña de Sysop de momento permi" \
   --add-entry="Activar" \
   --add-entry="Desactivar" \
   --add-entry="Activar (Sysop)" \
   --add-entry="Desactivar (Sysop)")

#echo ENABLE=$ENABLE
START=$(echo $ENABLE | cut -d '|' -f1)
STOP=$(echo $ENABLE | cut -d '|' -f2)
StartSysop=$(echo $ENABLE | cut -d '|' -f3)
StopSysop=$(echo $ENABLE | cut -d '|' -f4)


TIMES=$(zenity --forms \
  --title="Tiempos" \
  --text="El mensaje audio no puede ser más corto de $DuratioMin segundos y recomiendo no más de 60 segundos.\n\n En total en un día puede ser por ejemplo 1 hora, o sea 3600 segundos" \
  --width="600" \
  --height="300" \
  --add-entry="Por cada Mensaje" \
  --add-entry="Total en 1 día" )

#echo TIMES=$TIMES
OneMsg=$(echo $TIMES | cut -d '|' -f1)
TimeTotal=$(echo $TIMES | cut -d '|' -f2)


echo "AUDIODRIVER=$DiverSelect" > $HOME/.loro-config
echo "AUDIODEV=$AudioCard" >> $HOME/.loro-config
echo "TIME=$SilenceTime" >> $HOME/.loro-config
echo "MinMexDuration=$DuratioMin" >> $HOME/.loro-config
echo "FREQ=$FreqSelect" >> $HOME/.loro-config
echo "STOP=$STOP" >> $HOME/.loro-config
echo "START=$START" >> $HOME/.loro-config
echo "StopSysop=$StopSysop" >> $HOME/.loro-config
echo "StartSysop=$StartSysop" >> $HOME/.loro-config
echo "OneMsg=$OneMsg" >> $HOME/.loro-config
echo "TimeTotal=$TimeTotal" >> $HOME/.loro-config


